﻿//Nastavitve
var stTockZaNaslednjiLevel = 100;
var maxCasLevela = 30;
var casSadja = 10;
var stSadja = 2;
var vrednostSadja = 20;
var vrednostDrobtinice = 1;
//End Nastavitve

var movingDirection = "Down";
var nextMovingDirection = "N";

var pozicija; //pozicija pacMan-a
var score;
var level = 0;
var time;

var igraVTeku = false;

function changeCell(cell, znak) {
	cell.className = znak;
}

function getCell(row, col) {
	return document.getElementById("r"+row+"c"+col);
}

function addScore(sc) {
	score += sc;
	document.getElementById("score").innerHTML = score;
}

function move(direction) {
	var cellTo;
	
	if (direction == "Left") cellTo = getCell(pozicija.row, pozicija.col-1);
	else if (direction == "Right") cellTo = getCell(pozicija.row, pozicija.col+1);
	else if (direction == "Up") cellTo = getCell(pozicija.row-1, pozicija.col);
	else if (direction == "Down") cellTo = getCell(pozicija.row+1, pozicija.col);

	if (cellTo==undefined) return false;
	
	var cellFrom = getCell(pozicija.row, pozicija.col);
	
	var tmpClass = cellTo.className;
	
	//ugotovimo kam se je premaknil in ustrezno povečamo score
	if (tmpClass == ".") addScore(vrednostDrobtinice);
	else if (tmpClass == "S") addScore(vrednostSadja);

	if (tmpClass == "." || tmpClass == "S" || tmpClass == "N") {
		//po premiku zamenjamo ozadje celice kamor se je premaknil in od kod se je premaknil
		changeCell(cellTo, direction);
		changeCell(cellFrom, "N");
		
		//popravimo pozicijo pac-mana
		if (direction == "Up") pozicija.row--;
		else if (direction == "Down") pozicija.row++;
		else if (direction == "Left") pozicija.col--;
		else if (direction == "Right") pozicija.col++;
		
		return true;
	}
	
	return false;
}

function showSadje() {
	var st = 0;
	while (st != stSadja) {
		var rnd = Math.round(Math.random()*(30*40-1));//nakljucno stevilo
		if (PacmanMAP[level][rnd]=='.') {//preverimo če smo izbarli krogec
			st++;
			changeCell(getCell(Math.floor(rnd/40),rnd%40), "S");
		}
	}
}

function initialize() {
	score = 0;
	time = maxCasLevela;
	document.getElementById("map").innerHTML = "";
	var Pacman = PacmanMAP[level];
	document.getElementById("level").innerHTML = (level+1)+"/"+PacmanMAP.length;
	document.getElementById("time").innerHTML = time;
	pozicija = {row:Math.floor(Pacman.indexOf("P")/40), col:Pacman.indexOf("P")%40}
	for (var r = 0; r < 30; r++) {
		var row = document.createElement("tr");
		for (var c = 0; c < 40; c++) {
			var cell = document.createElement("td");
			cell.id = "r"+r+"c"+c;
			changeCell(cell, Pacman[(r)*40+c]);
			row.appendChild(cell);
		}
		document.getElementById("map").appendChild(row);
	}
	showSadje();
}

function run() {
	igraVTeku = true;
	//ura se nastavi vsako s
	var ura = setInterval(function() {
		time--;
		document.getElementById("time").innerHTML = time;
	},1000);
	
	//premaknemo se vsake 0.2 s
	var premik = setInterval(function() {
		if (!move(nextMovingDirection)) {
			move(movingDirection);
		} else {
			movingDirection = nextMovingDirection;
			nextMovingDirection = "N";
		}
	}, 200)
	
	//konec igre po 30 s
	setTimeout(function() {
		clearInterval(ura);
		clearInterval(premik);
		document.getElementById("time").innerHTML = 0;
		
		level++;
		if (score >= stTockZaNaslednjiLevel) {
			if (level == PacmanMAP.length) {
				alert("Bravo! Končali ste vse stopnje! Lahko igrate znova.");
				level = 0;
				initialize();
			} else {
				alert("Uspelo vam je priti v naslednji level!");
				initialize();
			}
		} else {
			alert("Ni vam uspelo! Začeti morate znova.");
			level = 0;
			initialize();
		}
		
		igraVTeku = false;
	}, maxCasLevela*1000);
	
	//po 10 s pobrišemo sadje
	setTimeout(function() {
		var sadje = document.getElementsByClassName("S");
		while (sadje.length>0) {
			changeCell(sadje[0], ".");
		}
	},casSadja*1000);
	
}


window.onload = function() {
	initialize();

	//keyCode LEFT=37, UP=38, RIGHT=39, DOWN=40
	//keyIdentifier Left, Up, Right, Down
	window.onkeydown = function(e) {
		if (e.keyCode >= 37 && e.keyCode <= 40) {
			var keyMaps = ["Left", "Up", "Right", "Down"];
			nextMovingDirection = keyMaps[e.keyCode-37];
			if (!igraVTeku) run();
		}
	}
	
}